# سیستم مدیریت تعطیلی رستوران - LimooFood API

## مقدمه

این سیستم امکان مدیریت تعطیلی‌های رستوران را در بازه‌های زمانی مختلف فراهم می‌کند. با استفاده از این سیستم، می‌توانید برای هر رستوران تعطیلی‌های مختلف تعریف کنید.

## ویژگی‌ها

### انواع تعطیلی

1. **تعطیلی تک روزه (`single_date`)**
   - تعطیلی در تاریخ خاص
   - مثال: تعطیلی رسمی، سالگرد

2. **تعطیلی بازه‌ای (`date_range`)**
   - تعطیلی در بازه زمانی مشخص
   - مثال: تعمیرات سالانه، سفر

3. **تعطیلی هفتگی (`weekly_pattern`)**
   - تعطیلی‌های تکرار شونده در روزهای هفته
   - مثال: تعطیلی دوشنبه‌ها

### قابلیت‌های اضافی

- **تعطیلی نیمه روز**: امکان تعریف تعطیلی فقط در ساعات خاص
- **تکرار سالانه**: تعطیلی‌هایی که هر سال تکرار می‌شوند
- **مدیریت وضعیت**: فعال/غیرفعال کردن تعطیلی‌ها
- **دلیل تعطیلی**: ثبت دلیل تعطیلی برای مدیریت بهتر

## ساختار دیتابیس

### جدول `branch_holidays`

```sql
CREATE TABLE `branch_holidays` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `branch_id` bigint UNSIGNED NOT NULL,
  `holiday_type` enum('single_date','date_range','weekly_pattern') NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NULL DEFAULT NULL,
  `start_time` time NULL DEFAULT NULL,
  `end_time` time NULL DEFAULT NULL,
  `is_full_day` tinyint(1) NOT NULL DEFAULT 1,
  `week_days` json NULL DEFAULT NULL,
  `repeat_yearly` tinyint(1) NOT NULL DEFAULT 0,
  `reason` varchar(255) NULL DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);
```

## API Endpoints

### مدیریت تعطیلی‌ها

#### دریافت لیست تعطیلی‌ها
```
GET /api/v1/holidays
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

**پارامترهای اختیاری:**
- `status`: فیلتر بر اساس وضعیت (active/inactive)
- `holiday_type`: فیلتر بر اساس نوع تعطیلی
- `start_date`: فیلتر از تاریخ
- `end_date`: فیلتر تا تاریخ

#### ایجاد تعطیلی جدید
```
POST /api/v1/holidays
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

**نمونه درخواست:**
```json
{
  "branch_id": 1,
  "holiday_type": "single_date",
  "start_date": "2025-02-11",
  "is_full_day": true,
  "reason": "تعطیلی رسمی",
  "status": "active"
}
```

#### به‌روزرسانی تعطیلی
```
PUT /api/v1/holidays/{holidayId}
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

#### حذف تعطیلی
```
DELETE /api/v1/holidays/{holidayId}
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

### بررسی وضعیت

#### بررسی وضعیت شعبه (باز یا بسته)
```
GET /api/v1/holidays/check-status
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

**پارامترهای اختیاری:**
- `date`: تاریخ بررسی (پیش‌فرض: امروز)
- `time`: زمان بررسی (پیش‌فرض: حالا)

#### دریافت تعطیلی‌های آینده
```
GET /api/v1/holidays/upcoming
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران

**پارامترهای اختیاری:**
- `limit`: تعداد نتایج (پیش‌فرض: 10)

#### دریافت تعطیلی‌های بازه زمانی
```
GET /api/v1/holidays/range
```

**پارامترهای الزامی:**
- `branch_id`: شناسه شعبه رستوران
- `start_date`: تاریخ شروع
- `end_date`: تاریخ پایان

## نمونه‌های استفاده

### 1. تعطیلی تک روزه
```json
{
  "branch_id": 1,
  "holiday_type": "single_date",
  "start_date": "2025-02-11",
  "is_full_day": true,
  "reason": "تعطیلی رسمی"
}
```

### 2. تعطیلی بازه‌ای
```json
{
  "branch_id": 1,
  "holiday_type": "date_range",
  "start_date": "2025-02-15",
  "end_date": "2025-02-17",
  "start_time": "09:00:00",
  "end_time": "18:00:00",
  "is_full_day": false,
  "reason": "تعمیرات سالانه"
}
```

### 3. تعطیلی هفتگی
```json
{
  "branch_id": 1,
  "holiday_type": "weekly_pattern",
  "start_date": "2025-01-01",
  "week_days": ["monday"],
  "is_full_day": true,
  "reason": "تعطیلی هفتگی دوشنبه‌ها"
}
```

### 4. نمونه‌های درخواست GET
```bash
# دریافت تعطیلی‌ها با فیلتر
GET /api/v1/holidays?branch_id=1&status=active&holiday_type=single_date

# بررسی وضعیت در تاریخ خاص
GET /api/v1/holidays/check-status?branch_id=1&date=2025-02-11&time=14:00:00

# تعطیلی‌های آینده با محدودیت
GET /api/v1/holidays/upcoming?branch_id=1&limit=5
```

## نصب و راه‌اندازی

### 1. اجرای Migration
```bash
php artisan migrate
```

### 2. اجرای Seeder (اختیاری)
```bash
php artisan db:seed --class=BranchHolidaySeeder
```

### 3. تست API

#### دریافت تعطیلی‌های یک شعبه
```bash
curl -X GET "http://localhost:8000/api/v1/holidays?branch_id=1"
```

#### ایجاد تعطیلی جدید
```bash
curl -X POST "http://localhost:8000/api/v1/holidays" \
  -H "Content-Type: application/json" \
  -d '{
    "branch_id": 1,
    "holiday_type": "single_date",
    "start_date": "2025-02-11",
    "is_full_day": true,
    "reason": "تعطیلی رسمی"
  }'
```

#### بررسی وضعیت شعبه
```bash
curl -X GET "http://localhost:8000/api/v1/holidays/check-status?branch_id=1"
```

#### دریافت تعطیلی‌های آینده
```bash
curl -X GET "http://localhost:8000/api/v1/holidays/upcoming?branch_id=1&limit=5"
```

#### دریافت تعطیلی‌های بازه زمانی
```bash
curl -X GET "http://localhost:8000/api/v1/holidays/range?branch_id=1&start_date=2025-02-01&end_date=2025-02-28"
```

## یکپارچه‌سازی با سیستم موجود

### بررسی وضعیت شعبه

سیستم تعطیلی به طور خودکار با سیستم ساعات کاری موجود یکپارچه شده است. هنگام بررسی وضعیت شعبه:

1. ابتدا بررسی می‌شود که آیا شعبه در تعطیلی قرار دارد
2. اگر در تعطیلی نباشد، ساعات کاری عادی بررسی می‌شود
3. نتیجه نهایی بر اساس هر دو بررسی تعیین می‌شود

### تغییرات در BranchRepository

متد `getNowStatus` به‌روزرسانی شده تا تعطیلی‌ها را نیز در نظر بگیرد.

### تغییرات در ساختار API

**قبل از تغییرات:**
- مسیرها: `/api/v1/branch/{branchId}/holidays`
- `branchId` در URL قرار داشت

**بعد از تغییرات:**
- مسیرها: `/api/v1/holidays`
- `branch_id` در پارامترهای درخواست ارسال می‌شود
- انعطاف‌پذیری بیشتر در مدیریت درخواست‌ها

## مدیریت خطا

سیستم شامل مدیریت خطای جامع است:

- **اعتبارسنجی داده‌ها**: بررسی صحت داده‌های ورودی
- **خطاهای دیتابیس**: مدیریت خطاهای مربوط به پایگاه داده
- **پیام‌های خطا**: پیام‌های واضح و مفید برای کاربران

## نکات مهم

1. **شناسه شعبه**: پارامتر `branch_id` در تمام درخواست‌ها الزامی است
2. **تاریخ‌ها**: از فرمت `Y-m-d` استفاده کنید
3. **زمان‌ها**: از فرمت `H:i:s` استفاده کنید
4. **روزهای هفته**: از نام‌های انگلیسی استفاده کنید (monday, tuesday, ...)
5. **تعطیلی‌های همزمان**: سیستم به طور خودکار تعطیلی‌های همزمان را مدیریت می‌کند
6. **تغییرات API**: تمام endpoints در مسیر `/api/v1/holidays` قرار دارند

## پشتیبانی

برای سوالات و مشکلات، لطفاً با تیم توسعه تماس بگیرید.
