<?php

namespace Modules\Blog\app\Http\Controllers\V1\Admin;

use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Modules\Blog\app\Repositories\Post\PostRepository;

class BlogController extends BaseController
{
    protected PostRepository $postRepository;

    public function __construct(PostRepository $postRepository)
    {
        $this->postRepository = $postRepository;
    }

    public function index(Request $request)
    {
        $filters = $request->all();
        $posts = $this->postRepository->getWithFilter($filters);
        return $this->sendResponse($posts, 'لیست پست‌ها با موفقیت دریافت شد');
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'cover' => 'required|url',
            'sm_description' => 'required|string|max:255',
            'keywords' => 'required|string|max:255',
            'author' => 'required|string|max:255',
            'post_category_id' => 'required|exists:post_categories,id',
        ]);
        if ($validator->fails()) {
            return $this->sendResponse([], $validator->errors()->first(), false, 400);
        }
        $data = $request->all();
        $post = $this->postRepository->store($data);
        if ($post) {
            return $this->sendResponse($post, 'پست با موفقیت ایجاد شد', 201);
        } else {
            return $this->sendError('خطا در ایجاد پست', [], 500);
        }
    }

    public function show(int $id)
    {
        $post = $this->postRepository->show($id, [], ['postCategory:id,title']);
        if ($post) {
            return $this->sendResponse($post, 'پست با موفقیت دریافت شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد', [], 404);
        }
    }

    public function update(Request $request, int $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'sm_description' => 'required|string|max:255',
            'keywords' => 'required|string|max:255',
            'cover' => 'required|url',
            'author' => 'required|string|max:255',
            'post_category_id' => 'required|exists:post_categories,id',
        ]);

        if ($validator->fails()) {
            return $this->sendResponse([], $validator->errors()->first(), false, 400);
        }
        Log::info("001");
        $data = $request->all();
        $updated = $this->postRepository->update($id, $data);
        Log::info($updated);

        if ($updated) {
            $post = $this->postRepository->show($id, [], 'postCategory:id,title');
            return $this->sendResponse($post, 'پست با موفقیت به‌روزرسانی شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد یا خطایی رخ داده است', [], 404);
        }
    }

    public function destroy(int $id)
    {
        $deleted = $this->postRepository->destroy($id);
        if ($deleted) {
            return $this->sendResponse([], 'پست با موفقیت حذف شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد یا خطایی رخ داده است', [], 404);
        }
    }
}
