<?php

namespace Modules\Blog\app\Http\Controllers\V1\Admin;

use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Modules\Blog\app\Repositories\PostCategory\PostCategoryRepository;

class PostCategoryController extends BaseController
{
    protected postCategoryRepository $postCategoryRepository;

    public function __construct(PostCategoryRepository $postCategoryRepository)
    {
        $this->postCategoryRepository = $postCategoryRepository;
    }

    public function index(Request $request)
    {
        $filters = $request->all();
        $posts = $this->postCategoryRepository->getWithFilter($filters);
        return $this->sendResponse($posts, '');
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'image' => 'nullable|url',
            'description' => 'nullable|string',
        ]);
        if ($validator->fails()) {
            return $this->sendResponse([], $validator->errors()->first(), false, 400);
        }
        $data = $request->all();
        $data['user_id'] = Auth::id();
        $post = $this->postCategoryRepository->store($data);
        if ($post) {
            return $this->sendResponse($post, '', 201);
        } else {
            return $this->sendError('خطا در ایجاد پست', [], 500);
        }
    }

    public function show(int $id)
    {
        $post = $this->postCategoryRepository->show($id);
        if ($post) {
            return $this->sendResponse($post, 'پست با موفقیت دریافت شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد', [], 404);
        }
    }

    public function update(Request $request, int $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'image' => 'nullable|url',
            'description' => 'nullable|string',
        ]);
        if ($validator->fails()) {
            return $this->sendResponse([], $validator->errors()->first(), false, 400);
        }
        $data = $request->all();
        $updated = $this->postCategoryRepository->update($id, $data);
        if ($updated) {
            $post = $this->postCategoryRepository->show($id);
            return $this->sendResponse($post, 'پست با موفقیت به‌روزرسانی شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد یا خطایی رخ داده است', [], 404);
        }
    }

    public function destroy(int $id)
    {
        $deleted = $this->postCategoryRepository->destroy($id);
        if ($deleted) {
            return $this->sendResponse([], 'پست با موفقیت حذف شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد یا خطایی رخ داده است', [], 404);
        }
    }
}
