<?php

namespace Modules\Blog\app\Http\Controllers\V1;

use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Modules\Blog\app\Repositories\PostCategory\PostCategoryRepository;

class PostCategoryController extends BaseController
{
    protected PostCategoryRepository $postRepository;

    public function __construct(PostCategoryRepository $postRepository)
    {
        $this->postRepository = $postRepository;
    }

    public function index(Request $request)
    {
        $filters = $request->all();
        $filters['status'] = "active";
        $filters['select'] = ["id", "title", "description", "created_at"];
        $posts = $this->postRepository->getWithFilter($filters, false);
        return $this->sendResponse($posts, 'لیست دسته بندی ها با موفقیت دریافت شد.');
    }

}
