<?php

namespace Modules\Blog\app\Repositories\Post;

use App\Models\BankAccount;

class PostRepository extends EloquentRepository
{
    public function model()
    {
        return BankAccount::class;
    }

    public function getWithFilter(array $filter = [], $paginate = true)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {

                if (isset($filter['user_id']) && !empty($filter['user_id'])) {
                    $q->where('user_id', $filter['user_id']);
                }

                if (isset($filter['title']) && !empty($filter['title'])) {
                    $q->where('title', 'LIKE', '%' . $filter['title'] . '%');
                }

                if (isset($filter['status']) && !empty($filter['status'])) {
                    $q->where('status', $filter['status']);
                }

                if (isset($filter['post_category_id']) && !empty($filter['post_category_id'])) {
                    $q->where('post_category_id', $filter['post_category_id']);
                }

            })->orderBy('id', 'desc')->with('postCategory:id,title');
            if (isset($filter['select']) && !empty($filter['select'])) {
                $data->select($filter['select']);
            }
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            handelError('error', $e->getMessage());
            return null;
        }
    }


}
