<?php

namespace Modules\Blog\app\Repositories\PostCategory;

use Modules\Blog\app\Models\PostCategory;

class PostCategoryRepository extends EloquentRepository
{
    public function model()
    {
        return PostCategory::class;
    }

    public function getWithFilter(array $filter = [], $paginate = true)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['title']) && !empty($filter['title'])) {
                    $q->where('title', 'LIKE', '%' . $filter['title'] . '%');
                }

                if (isset($filter['status']) && !empty($filter['status'])) {
                    $q->where('status', $filter['status']);
                }

            })->orderBy('id', 'desc');

            if (isset($filter['select']) && !empty($filter['select'])) {
                $data->select($filter['select']);
            }


            if (isset($filter['paginate']) && !empty($filter['paginate']) and $filter['paginate'] == true) {
                $paginateCount = 25;
                if (isset($filter['paginateCount']))
                    $paginateCount = $filter['paginateCount'];
                return $data->paginate($paginateCount);
            }

            return $data->get();


        } catch
        (\Exception $e) {
            handelError('error', $e->getMessage());
            return null;
        }
    }


}
