<?php

use Illuminate\Support\Facades\Route;


Route::middleware([])->prefix('v1')->group(function () {
    Route::prefix('post')->name('post.')->group(function () {
        Route::get('/', [\Modules\Blog\app\Http\Controllers\V1\PostController::class, 'index'])->name('index');
        Route::get('/show/{id}', [\Modules\Blog\app\Http\Controllers\V1\PostController::class, 'show'])->name('show');
    });
    Route::prefix('post-category')->name('postCategory.')->group(function () {
        Route::get('/', [\Modules\Blog\app\Http\Controllers\V1\PostCategoryController::class, 'index'])->name('index');
    });
});
Route::middleware(['auth:api'])->prefix('v1')->name('api.v1.')->group(function () {
    Route::middleware(['auth:api', 'CheckAccess'])->prefix('admin')->name('admin.')->group(function () {

        Route::prefix('post')->name('post.')->group(function () {
            Route::get('/', [\Modules\Blog\app\Http\Controllers\V1\Admin\BlogController::class, 'index'])->name('index');
            Route::get('/show/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\BlogController::class, 'show'])->name('show');
            Route::post('/store', [\Modules\Blog\app\Http\Controllers\V1\Admin\BlogController::class, 'store'])->name('store');
            Route::put('/update/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\BlogController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\BlogController::class, 'destroy'])->name('destroy');
        });
        Route::prefix('post-category')->name('postCategory.')->group(function () {
            Route::get('/', [\Modules\Blog\app\Http\Controllers\V1\Admin\PostCategoryController::class, 'index'])->name('index');
            Route::get('/show/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\PostCategoryController::class, 'show'])->name('show');
            Route::post('/store', [\Modules\Blog\app\Http\Controllers\V1\Admin\PostCategoryController::class, 'store'])->name('store');
            Route::put('/update/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\PostCategoryController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [\Modules\Blog\app\Http\Controllers\V1\Admin\PostCategoryController::class, 'destroy'])->name('destroy');
        });

    });
});
