<?php

namespace Modules\Cashier\app\Http\Controllers\V1\Admin;

use App\Enums\TransactionType;
use App\Http\Controllers\BaseController;
use App\Models\Order;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Delivery\DeliveryRepository;
use App\Repositories\Transaction\TransactionRepository;
use App\Repositories\User\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Modules\Cashier\app\Repositories\Order\OrderCashier;

class OrderController extends BaseController
{
    protected OrderCashier $orderCashier;

    public function __construct(OrderCashier $orderCashier)
    {
        $this->orderCashier = $orderCashier;
    }

    public function create(Request $request)
    {
        DB::beginTransaction();
        try {
            $data = $request->all();
            $carts = $data['carts'];
            unset($data['carts']);
            $data = $this->orderCashier->store($data);
            foreach (json_decode($carts,true) as $item) {
                $response = $this->orderCashier->addCartOrder([
                    'order_id' => $data['id'],
                    'variety_id' => $item['variety_id'],
                    'count' => $item['count'],
                    'extras' => null,
                    'extra_ids' => null,
                    'price' => $item['variety_price'],
                    'discount' => $item['variety_discount'],
                    'description'=>$item['description']
                ]);
            }

            if(isset($request->wallet_use_price) and $request->wallet_use_price>0)
            {
                app(TransactionRepository::class)->storeP(['amount' =>$request->wallet_use_price*-1 , 'target_id' => $data['id'], 'user_id' => $data['user_id'], 'transaction_type' => TransactionType::SALES, 'description' => 'سفارش  : ' . $data['id']]);
            }

            //sms
            //send_customer_to_courier
           // send_courier_to_customer

           if(isset($request->printAfterSave)and $request->printAfterSave)
           {
            event(new \App\Events\NotificationOrder($data));
            event(new \App\Events\PrintOrder($data));


           }

            if(isset($request->send_link)and $request->send_link)
            {
                Log::info($request->order_price);
                Log::info($request->order_price_payed);
                Log::info($request->order_price- $request->order_price_payed);
            }
            DB::commit();
            return ['status' => 200, 'message' => 'سفارش ثبت شد', 'data' => $data];
        } catch (\Exception $e) {
            handelError('error', $e);
            DB::rollBack();
            return ['status' => 500, 'message' => 'عملیات با شکست روبرو شد مجدد تلاش کنید ', 'data' => null];
        }
    }


    public function update(Order $order,Request $request)
    {
        DB::beginTransaction();
        try {

            $data = $request->all();
            if(isset( $data['carts'])){
            $carts = $data['carts'];
            unset($data['carts']);
            }
            $this->orderCashier->createOrderHistories($order->id);
            
            if(!isset($data['driver_id']))
            $data['driver_id']=null;
    
            if(!isset($data['public_driver']))
             $data['public_driver']=null;

            
             $this->orderCashier->removeCarts($order->id);

            if(isset($carts) and $carts!=null){
            
            foreach (json_decode($carts,true) as $item) {
                $response = $this->orderCashier->addCartOrder([
                    'order_id' => $order->id,
                    'variety_id' => $item['variety_id'],
                    'count' => $item['count'],
                    'extras' => null,
                    'extra_ids' => null,
                    'price' => $item['variety_price'],
                    'discount' => $item['variety_discount'],
                    'description'=>$item['description']
                ]);
            }}

            $data = $this->orderCashier->update($order->id,$data);

            $user=auth()->user();
            if($user->role_id==1 and isset($request->walletAfterUpdate) and $request->walletAfterUpdatePrice>0)
            {
                app(TransactionRepository::class)->storeP(['amount' =>$request->walletAfterUpdatePrice , 'target_id' => $order->id, 'user_id' => $order->user_id, 'transaction_type' => TransactionType::RETURNEDSYSTEM, 'description' => 'برگشت ویرایش سفارش  : ' . $order->id]);
            }
            DB::commit();
            return ['status' => 200, 'message' => 'سفارش ثبت شد', 'data' => $data];
        } catch (\Exception $e) {
            handelError('error', $e);
            DB::rollBack();
            return ['status' => 500, 'message' => 'عملیات با شکست روبرو شد مجدد تلاش کنید ', 'data' => null];
        }
    }



    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'order_id' => 'required|numeric|exists:orders,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        
        $order = $this->orderCashier->showC($request->order_id);
        if (!$order) {
            return response()->json(['message' => 'دسته بندی یافت نشد'], 404);
        }

        return response()->json(['data' => $order]);
    }





    public function addCart(Request $request)
    {
        $code = $this->orderCashier->createOrderWithToken($request['branch_id']);

        //get_all_type_delivery
        $deliveryType = app(DeliveryRepository::class)->getDeliveryTypes($request['branch_id']);

        //get_category_and_product
        $data = $request->all();
        $data['select'] = ['id', 'title', 'img', 'parent_id', 'branch_id', 'start_serving', 'end_serving'];
        $category = app(CategoryRepository::class)->getCategoryAllWithProduct($data);
        return response()->json([
            'message' => '',
            'data' => ['delivery_types' => $deliveryType['data'] ?? [], 'category' => $category, 'code' => $code],
            'status' => 200,
        ]);
    }

    public function add(Request $request)
    {
        $response = $this->orderCashier->addCartOrder($request->all());
        return response()->json($response, $response['status']);
    }

    public function mines(Request $request)
    {
        $response = $this->orderCashier->decrementCartOrder($request->all());
        return response()->json($response, $response['status']);
    }

    public function userInfo(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|numeric|digits:11',
        ]);
        if ($validator->fails()) {
            return response()->json(['data' => [], 'message' => $validator->errors()->first(), 'status' => 401], 401);
        }

        $userRep = app(UserRepository::class);
        $user = $userRep->getUserWithMobile($request->mobile);
        $user->address;
        return ['status' => 200, 'message' => '', 'data' => $user];
    }

    public function products(Request $request)
    {
        $data = $request->all();
        $data['select'] = ['id', 'title', 'img', 'parent_id', 'branch_id', 'start_serving', 'end_serving'];
        $category = app(CategoryRepository::class)->getCategoryAllWithProduct($data);
        return response()->json([
            'message' => '',
            'data' => $category,
            'status' => 200,
        ]);
    }
}
