<?php

namespace Modules\Blog\app\Http\Controllers\V1;

use App\Http\Controllers\BaseController;
use Illuminate\Http\Request;
use Modules\Blog\app\Repositories\Post\PostRepository;

class PostController extends BaseController
{
    protected PostRepository $postRepository;

    public function __construct(PostRepository $postRepository)
    {
        $this->postRepository = $postRepository;
    }

    public function index(Request $request)
    {
        $filters = $request->all();
        $filters['status'] = "published";
        $filters['select'] = ["id", "title", "cover", "content", "author", "post_category_id", "created_at"];
        $posts = $this->postRepository->getWithFilter($filters);
        return $this->sendResponse($posts, 'لیست پست‌ها با موفقیت دریافت شد');
    }

    public function show(int $id)
    {
        $post = $this->postRepository->show($id, ['status' => 'published'], 'postCategory:id,title', ["id", "cover","keywords","sm_description", "title", "content", "author", "post_category_id", "created_at"]);
        if ($post) {
            return $this->sendResponse($post, 'پست با موفقیت دریافت شد');
        } else {
            return $this->sendError('پست مورد نظر یافت نشد', [], 404);
        }
    }
}
