<?php

namespace Modules\Cashier\app\Repositories\Order;

use App\Models\Order;
use App\Models\OrderCart;
use App\Models\OrderHistory;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Order\OrderRepository;
use App\Repositories\User\UserRepository;
use App\Repositories\Variety\VarietyRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use ZipStream\LocalFileHeader;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Order $model)
    {
        parent::__construct($model);
    }


    public function showC($id)
    {
        try {
            return $this->model->where('id', $id)->with('customer','driver', 'orderCart','deliveryType:id,title')->first();
        } catch (\Exception $e) {
            return null;
        }
    }

    public function addCartOrder($data)
    {
        $cart = OrderCart::create($data);
    }

    
    public function createOrderHistories($id)
    {
        OrderHistory::create(['order_id'=>$id,'old_data'=>json_encode($this->showC($id)['data']??[])]);
    }

    
    public function removeCarts($id)
    {
        $order=$this->model->find($id);
        $order->orderCart()->delete();
    }


}
