<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:sanctum'])->prefix('v1')->name('api.')->group(function () {
    Route::get('cashier', fn(Request $request) => $request->user())->name('cashier');
});


Route::middleware(['auth:api'])->prefix('v1')->name('api.v1.')->group(function () {
    Route::middleware([/*'CheckAccess'*/])->prefix('admin')->name('admin.')->group(function () {

        Route::prefix('cashier')->name('cashier.')->group(function () {
            Route::prefix('order')->name('order.')->group(function () {
                Route::get('/show', [\Modules\Cashier\app\Http\Controllers\V1\Admin\OrderController::class, 'show'])->name('show');

                Route::post('/create', [\Modules\Cashier\app\Http\Controllers\V1\Admin\OrderController::class, 'create'])->name('create');
                Route::put('/update/{order}', [\Modules\Cashier\app\Http\Controllers\V1\Admin\OrderController::class, 'update'])->name('update');

                
                Route::get('/user-info', [\Modules\Cashier\app\Http\Controllers\V1\Admin\OrderController::class, 'userInfo'])->name('searchUserAndGetData');
                
            });
        });
    });
});
