# API Documentation - ماژول Courier (پیک)

## Base URL
```
/api/v1/couriers
```

## Authentication
تمام روت‌ها نیاز به احراز هویت دارند. از Bearer Token استفاده کنید:
```
Authorization: Bearer {your-token}
```

---

## 1. دریافت لیست پیک‌ها

### `GET /api/v1/couriers`

لیست تمام پیک‌ها را با قابلیت فیلتر و صفحه‌بندی برمی‌گرداند.

#### Query Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `search` | string | No | جستجو در نام، نام خانوادگی، شماره موبایل و کد ملی |
| `name` | string | No | فیلتر بر اساس نام |
| `family` | string | No | فیلتر بر اساس نام خانوادگی |
| `mobile` | string | No | فیلتر بر اساس شماره موبایل |
| `national_code` | string | No | فیلتر بر اساس کد ملی |
| `branch_id` | integer | No | فیلتر بر اساس شناسه شعبه |
| `user_id` | integer | No | فیلتر بر اساس شناسه کاربر |
| `delivery_percent` | decimal | No | فیلتر بر اساس درصد کمیسیون |
| `phone` | string | No | فیلتر بر اساس شماره تلفن |
| `per_page` | integer | No | تعداد آیتم در هر صفحه (پیش‌فرض: 15) |
| `page` | integer | No | شماره صفحه |

#### Example Request
```bash
GET /api/v1/couriers?search=احمد&branch_id=1&per_page=10
```

#### Example Response
```json
{
    "status": "success",
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1,
                "name": "احمد",
                "family": "محمدی",
                "mobile": "09123456789",
                "national_code": "1234567890",
                "birth_date": "1380/05/15",
                "address": "تهران، خیابان ولیعصر",
                "branch_id": 1,
                "branch": {
                    "id": 1,
                    "name": "شعبه مرکزی"
                },
                "user": {
                    "id": 1,
                    "name": "احمد",
                    "family": "محمدی",
                    "mobile": "09123456789",
                    "national_code": "1234567890",
                    "birth_date": "1380/05/15"
                },
                "delivery_times": [
                    {
                        "id": 1,
                        "start_time": "08:00",
                        "end_time": "18:00"
                    }
                ],
                "delivery_percent": "15.50",
                "phone": "09123456789",
                "created_at": "2024-01-01T00:00:00.000000Z",
                "updated_at": "2024-01-01T00:00:00.000000Z"
            }
        ],
        "first_page_url": "...",
        "from": 1,
        "last_page": 1,
        "last_page_url": "...",
        "next_page_url": null,
        "path": "...",
        "per_page": 10,
        "prev_page_url": null,
        "to": 1,
        "total": 1
    }
}
```

---

## 2. ایجاد پیک جدید

### `POST /api/v1/couriers`

پیک جدید ایجاد می‌کند. اگر کاربر با شماره موبایل موجود باشد، از همان کاربر استفاده می‌کند.

#### Request Body

| Field | Type | Required | Description |
|-------|------|----------|-------------|
| `name` | string | Yes | نام پیک |
| `family` | string | Yes | نام خانوادگی پیک |
| `mobile` | string | Yes | شماره موبایل |
| `national_code` | string | Yes | کد ملی (10-11 کاراکتر) |
| `birth_date` | string | No | تاریخ تولد (فرمت: YYYY/MM/DD) |
| `address` | string | No | آدرس |
| `branch_id` | integer | Yes | شناسه شعبه |
| `delivery_percent` | decimal | No | درصد کمیسیون (0-100) |
| `delivery_times` | array | No | ساعات کاری |
| `delivery_times.*.start_time` | string | Yes | زمان شروع (فرمت: HH:MM) |
| `delivery_times.*.end_time` | string | Yes | زمان پایان (فرمت: HH:MM) |

#### Example Request
```json
{
    "name": "احمد",
    "family": "محمدی",
    "mobile": "09123456789",
    "national_code": "1234567890",
    "birth_date": "1380/05/15",
    "address": "تهران، خیابان ولیعصر",
    "branch_id": 1,
    "delivery_percent": 15.5,
    "delivery_times": [
        {
            "start_time": "08:00",
            "end_time": "18:00"
        },
        {
            "start_time": "19:00",
            "end_time": "23:00"
        }
    ]
}
```

#### Example Response
```json
{
    "status": "success",
    "message": "پیک با موفقیت ایجاد شد",
    "data": {
        "id": 1,
        "name": "احمد",
        "family": "محمدی",
        "mobile": "09123456789",
        "national_code": "1234567890",
        "birth_date": "1380/05/15",
        "address": "تهران، خیابان ولیعصر",
        "branch_id": 1,
        "delivery_percent": "15.50",
        "delivery_times": [...],
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z"
    }
}
```

---

## 3. جستجو و ایجاد پیک

### `POST /api/v1/couriers/search-and-create`

ابتدا کاربر را جستجو می‌کند و اگر موجود باشد، پیک ایجاد می‌کند. اگر کاربر موجود نباشد، ابتدا کاربر جدید ایجاد می‌کند.

#### Request Body
همان فیلدهای ایجاد پیک جدید

#### Example Response
```json
{
    "status": "success",
    "message": "پیک با موفقیت ایجاد شد",
    "data": {
        "id": 1,
        "user": {
            "id": 1,
            "name": "احمد",
            "family": "محمدی",
            "mobile": "09123456789",
            "national_code": "1234567890",
            "birth_date": "1380/05/15"
        },
        "branch": {
            "id": 1,
            "name": "شعبه مرکزی"
        },
        "delivery_times": [...]
    }
}
```

---

## 4. جستجوی کاربران

### `GET /api/v1/couriers/search-users`

جستجو در کاربران موجود برای انتخاب به عنوان پیک.

#### Query Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `query` | string | Yes* | عبارت جستجو |
| `search` | string | Yes* | عبارت جستجو (معادل query) |

*یکی از دو پارامتر `query` یا `search` الزامی است.

#### Example Request
```bash
GET /api/v1/couriers/search-users?query=احمد
```

#### Example Response
```json
{
    "status": "success",
    "data": [
        {
            "id": 1,
            "name": "احمد",
            "family": "محمدی",
            "mobile": "09123456789",
            "national_code": "1234567890",
            "birth_date": "1380/05/15"
        }
    ]
}
```

---

## 5. دریافت اطلاعات پیک

### `GET /api/v1/couriers/{id}`

اطلاعات کامل یک پیک را برمی‌گرداند.

#### Path Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `id` | integer | Yes | شناسه پیک |

#### Example Request
```bash
GET /api/v1/couriers/1
```

#### Example Response
```json
{
    "status": "success",
    "data": {
        "id": 1,
        "name": "احمد",
        "family": "محمدی",
        "mobile": "09123456789",
        "national_code": "1234567890",
        "birth_date": "1380/05/15",
        "address": "تهران، خیابان ولیعصر",
        "branch_id": 1,
        "branch": {
            "id": 1,
            "name": "شعبه مرکزی"
        },
        "user": {
            "id": 1,
            "name": "احمد",
            "family": "محمدی",
            "mobile": "09123456789",
            "national_code": "1234567890",
            "birth_date": "1380/05/15"
        },
        "delivery_times": [...],
        "delivery_percent": "15.50",
        "phone": "09123456789",
        "created_at": "2024-01-01T00:00:00.000000Z",
        "updated_at": "2024-01-01T00:00:00.000000Z"
    }
}
```

---

## 6. ویرایش پیک

### `PUT /api/v1/couriers/{id}`

اطلاعات پیک و کاربر مربوطه را ویرایش می‌کند.

#### Path Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `id` | integer | Yes | شناسه پیک |

#### Request Body
همان فیلدهای ایجاد پیک جدید

#### Example Request
```json
{
    "name": "احمد",
    "family": "محمدی",
    "mobile": "09123456789",
    "national_code": "1234567890",
    "birth_date": "1380/05/15",
    "address": "تهران، خیابان ولیعصر جدید",
    "branch_id": 1,
    "delivery_percent": 20.0,
    "delivery_times": [
        {
            "start_time": "09:00",
            "end_time": "17:00"
        }
    ]
}
```

#### Example Response
```json
{
    "status": "success",
    "message": "پیک با موفقیت بروزرسانی شد"
}
```

---

## 7. حذف پیک

### `DELETE /api/v1/couriers/{id}`

پیک را به صورت نرم حذف می‌کند (Soft Delete).

#### Path Parameters

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `id` | integer | Yes | شناسه پیک |

#### Example Request
```bash
DELETE /api/v1/couriers/1
```

#### Example Response
```json
{
    "status": "success",
    "message": "پیک با موفقیت حذف شد"
}
```

---

## Error Responses

### Validation Error (422)
```json
{
    "status": "error",
    "message": "خطا در اعتبارسنجی داده‌ها",
    "errors": {
        "name": ["نام الزامی است."],
        "national_code": ["کد ملی باید حداقل 10 کاراکتر باشد."]
    }
}
```

### Not Found Error (404)
```json
{
    "status": "error",
    "message": "پیک یافت نشد"
}
```

### Server Error (500)
```json
{
    "status": "error",
    "message": "خطا در سرور",
    "error": "Error details"
}
```

---

## Validation Rules

### فیلدهای الزامی
- `name`: required|string|max:255
- `family`: required|string|max:255
- `mobile`: required|string|max:20
- `national_code`: required|string|max:11|min:10
- `branch_id`: required|integer|exists:branches,id

### فیلدهای اختیاری
- `birth_date`: nullable|string
- `address`: nullable|string
- `delivery_percent`: nullable|numeric|min:0|max:100
- `delivery_times`: nullable|array
- `delivery_times.*.start_time`: required|date_format:H:i
- `delivery_times.*.end_time`: required|date_format:H:i|after:delivery_times.*.start_time

---

## Notes

1. **تاریخ تولد**: به صورت رشته با فرمت `YYYY/MM/DD` ذخیره می‌شود
2. **ساعات کاری**: زمان‌ها به فرمت `HH:MM` ارسال می‌شوند
3. **درصد کمیسیون**: عدد اعشاری بین 0 تا 100
4. **کد ملی**: بین 10 تا 11 کاراکتر
5. **Soft Delete**: حذف پیک به صورت نرم انجام می‌شود
6. **Transaction**: تمام عملیات در تراکنش انجام می‌شود
