<?php

namespace Modules\Courier\app\Exceptions;

use Exception;

class CourierException extends Exception
{
    /**
     * Create a new courier exception instance.
     */
    public function __construct(string $message = 'Courier operation failed', int $code = 0, Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    /**
     * Report the exception.
     */
    public function report(): void
    {
        // Log the exception if needed
    }

    /**
     * Render the exception into an HTTP response.
     */
    public function render($request)
    {
        if ($request->expectsJson()) {
            return response()->json([
                'status' => 'error',
                'message' => $this->getMessage(),
                'code' => $this->getCode()
            ], 400);
        }

        return back()->withErrors(['error' => $this->getMessage()]);
    }
}
