<?php

namespace Modules\Courier\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CourierOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => [
                'required',
                'integer',
                'exists:users,id'
            ],
            'per_page' => [
                'nullable',
                'integer',
                'min:1',
                'max:100'
            ],
            'order_status' => [
                'nullable',
                'string',
                Rule::in([
                    'ordering',
                    'wating_payment',
                    'awaiting_restaurant_approval',
                    'preparing',
                    'sending',
                    'delivered',
                    'ready_to_send',
                    'returned',
                    'cancelled'
                ])
            ],
            'start_date' => [
                'nullable',
                'date_format:Y/m/d'
            ],
            'end_date' => [
                'nullable',
                'date_format:Y/m/d',
                'after_or_equal:start_date'
            ],
            'payment_status' => [
                'nullable',
                'string',
                Rule::in(['true', 'false'])
            ],
            'branch_id' => [
                'nullable',
                'integer',
                'exists:branches,id'
            ]
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'user_id.required' => 'شناسه کاربر اجباری است',
            'user_id.integer' => 'شناسه کاربر باید عدد باشد',
            'user_id.exists' => 'کاربر یافت نشد',
            'per_page.integer' => 'تعداد آیتم در صفحه باید عدد باشد',
            'per_page.min' => 'حداقل تعداد آیتم در صفحه 1 است',
            'per_page.max' => 'حداکثر تعداد آیتم در صفحه 100 است',
            'order_status.in' => 'وضعیت سفارش انتخاب شده معتبر نیست',
            'start_date.date_format' => 'فرمت تاریخ شروع باید Y/m/d باشد',
            'end_date.date_format' => 'فرمت تاریخ پایان باید Y/m/d باشد',
            'end_date.after_or_equal' => 'تاریخ پایان باید بعد از تاریخ شروع یا برابر با آن باشد',
            'payment_status.in' => 'وضعیت پرداخت انتخاب شده معتبر نیست',
            'branch_id.integer' => 'شناسه شعبه باید عدد باشد',
            'branch_id.exists' => 'شعبه یافت نشد'
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string, string>
     */
    public function attributes(): array
    {
        return [
            'user_id' => 'شناسه کاربر',
            'per_page' => 'تعداد آیتم در صفحه',
            'order_status' => 'وضعیت سفارش',
            'start_date' => 'تاریخ شروع',
            'end_date' => 'تاریخ پایان',
            'payment_status' => 'وضعیت پرداخت',
            'branch_id' => 'شناسه شعبه'
        ];
    }
}
