<?php

namespace Modules\Courier\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;
class CourierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        Log::info('CourierRequest', $this->all());
        $rules = [
            'name' => 'required|string|max:255',
            'family' => 'required|string|max:255',
            'mobile' => 'required|string|max:20',
            'national_code' => 'required|string|max:11|min:10',
            'address' => 'nullable|string',
            'branch_id' => 'required|integer|exists:branches,id',
            'delivery_percent' => 'nullable|numeric|min:0|max:100',
            'phone' => 'nullable|string|max:20',
            'birth_date' => 'nullable|string',
        ];

        // Add delivery times validation if present
        if ($this->has('delivery_times')) {
            $rules['delivery_times'] = 'array';
            $rules['delivery_times.*.start_time'] = 'required';
            $rules['delivery_times.*.end_time'] = 'required';
        }

        return $rules;
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'نام الزامی است.',
            'name.string' => 'نام باید متن باشد.',
            'name.max' => 'نام نمی‌تواند بیشتر از 255 کاراکتر باشد.',
            'family.required' => 'نام خانوادگی الزامی است.',
            'family.string' => 'نام خانوادگی باید متن باشد.',
            'family.max' => 'نام خانوادگی نمی‌تواند بیشتر از 255 کاراکتر باشد.',
            'mobile.required' => 'شماره موبایل الزامی است.',
            'mobile.string' => 'شماره موبایل باید متن باشد.',
            'mobile.max' => 'شماره موبایل نمی‌تواند بیشتر از 20 کاراکتر باشد.',
            'national_code.required' => 'کد ملی الزامی است.',
            'national_code.string' => 'کد ملی باید متن باشد.',
            'national_code.max' => 'کد ملی نمی‌تواند بیشتر از 11 کاراکتر باشد.',
            'national_code.min' => 'کد ملی نمی‌تواند کمتر از 10 کاراکتر باشد.',
            'branch_id.required' => 'انتخاب شعبه الزامی است.',
            'branch_id.integer' => 'شناسه شعبه باید عدد باشد.',
            'branch_id.exists' => 'شعبه انتخاب شده معتبر نیست.',
            'delivery_percent.numeric' => 'درصد کمیسیون باید عدد باشد.',
            'delivery_percent.min' => 'درصد کمیسیون نمی‌تواند کمتر از 0 باشد.',
            'delivery_percent.max' => 'درصد کمیسیون نمی‌تواند بیشتر از 100 باشد.',
            'phone.string' => 'شماره تلفن باید متن باشد.',
            'phone.max' => 'شماره تلفن نمی‌تواند بیشتر از 20 کاراکتر باشد.',
            'delivery_times.array' => 'ساعات کاری باید آرایه باشد.',
            'delivery_times.*.start_time.required' => 'زمان شروع الزامی است.',
            'delivery_times.*.start_time.date_format' => 'فرمت زمان شروع صحیح نیست.',
            'delivery_times.*.end_time.required' => 'زمان پایان الزامی است.',
            'delivery_times.*.end_time.date_format' => 'فرمت زمان پایان صحیح نیست.',
            'delivery_times.*.end_time.after' => 'زمان پایان باید بعد از زمان شروع باشد.',
            'birth_date.string' => 'تاریخ تولد باید تاریخ باشد.',
        ];
    }
}
