<?php

namespace Modules\Courier\app\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CourierOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'order_status' => $this->order_status,
            'payment_status' => $this->payment_status,
            'payment_type' => $this->payment_type,
            'order_price' => $this->order_price,
            'order_price_payed' => $this->order_price_payed,
            'delivery_price' => $this->delivery_price,
            'cash_back_price' => $this->cash_back_price,
            'tax_price' => $this->tax_price,
            'discount_price' => $this->discount_price,
            'delivery_time' => $this->delivery_time,
            'preparation_time' => $this->preparation_time,
            'description' => $this->description,
            'pager_number' => $this->pager_number,
            'table_number' => $this->table_number,
            'kitchen_description' => $this->kitchen_description,
            'type_order' => $this->type_order,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_at_jalali' => $this->created_at_jalali ?? null,
            'updated_at_jalali' => $this->updated_at_jalali ?? null,

            // Address information
            'address' => $this->when($this->address, [
                'title' => $this->address['title'] ?? null,
                'address' => $this->address['address'] ?? null,
                'lat' => $this->address['lat'] ?? null,
                'lng' => $this->address['lng'] ?? null,
                'phone_number' => $this->address['phone_number'] ?? null,
            ]),

            // User information
            'user' => $this->when($this->user, [
                'id' => $this->user->id,
                'name' => $this->user->name,
                'family' => $this->user->family,
                'mobile' => $this->user->mobile,
                'email' => $this->user->email,
            ]),

            // Branch information
            'branch' => $this->when($this->branch, [
                'id' => $this->branch->id,
                'title' => $this->branch->title,
                'address' => $this->branch->address,
                'logo' => $this->branch->logo,
                'min_order' => $this->branch->min_order,
                'vendor_id' => $this->branch->vendor_id,
            ]),

            // Driver information
            'driver' => $this->when($this->driver, [
                'id' => $this->driver->id,
                'name' => $this->driver->name,
                'family' => $this->driver->family,
                'mobile' => $this->driver->phone,
                'delivery_percent' => $this->driver->delivery_percent,
                'user' => $this->when($this->driver->user, [
                    'id' => $this->driver->user->id,
                    'name' => $this->driver->user->name,
                    'family' => $this->driver->user->family,
                    'mobile' => $this->driver->user->mobile,
                ]),
            ]),

            // Delivery type information
            'delivery_type' => $this->when($this->deliveryType, [
                'id' => $this->deliveryType->id,
                'title' => $this->deliveryType->title,
            ]),

            // Order cart items
            'order_cart' => $this->when($this->orderCart, function () {
                return $this->orderCart->map(function ($item) {
                    return [
                        'id' => $item->id,
                        'count' => $item->count,
                        'price' => $item->price,
                        'discount' => $item->discount,
                        'description' => $item->description,
                        'extras' => $item->extras,
                        'variety' => $this->when($item->variety, [
                            'id' => $item->variety->id,
                            'title' => $item->variety->title,
                            'price' => $item->variety->price,
                        ]),
                    ];
                });
            }),
        ];
    }
}
