<?php

namespace Modules\Courier\app\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CourierOrderStatsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'total_orders' => $this->resource['total_orders'],
            'delivered_orders' => $this->resource['delivered_orders'],
            'in_progress_orders' => $this->resource['in_progress_orders'],
            'cancelled_orders' => $this->resource['cancelled_orders'],
            'total_earnings' => $this->resource['total_earnings'],
            'average_delivery_time' => $this->resource['average_delivery_time'],
            'delivery_rate' => $this->resource['total_orders'] > 0
                ? round(($this->resource['delivered_orders'] / $this->resource['total_orders']) * 100, 2)
                : 0,
            'cancellation_rate' => $this->resource['total_orders'] > 0
                ? round(($this->resource['cancelled_orders'] / $this->resource['total_orders']) * 100, 2)
                : 0,
        ];
    }
}
