<?php

namespace Modules\Courier\app\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CourierResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'family' => $this->family,
            'mobile' => $this->mobile,
            'national_code' => $this->national_code,
            'address' => $this->address,
            'branch_id' => $this->branch_id,
            'branch' => [
                'id' => $this->branch?->id,
                'name' => $this->branch?->name,
            ],
            'user' => [
                'id' => $this->user?->id,
                'name' => $this->user?->name,
                'family' => $this->user?->family,
                'mobile' => $this->user?->mobile,
                'national_code' => $this->user?->national_code,
                'birth_date' => $this->user?->birth_date,
            ],
            'delivery_times' => $this->deliveryTimes->map(function ($time) {
                return [
                    'id' => $time->id,
                    'start_time' => $time->start_time,
                    'end_time' => $time->end_time,
                ];
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
