<?php

namespace Modules\Courier\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DeliveryTime extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'branch_courier_id',
        'start_time',
        'end_time',
    ];

    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    protected $casts = [
        'branch_courier_id' => 'integer',
        'start_time' => 'string',
        'end_time' => 'string',
    ];

    /**
     * Get the courier that owns the delivery time.
     */
    public function courier(): BelongsTo
    {
        return $this->belongsTo(BranchCourier::class, 'branch_courier_id');
    }

    /**
     * Scope to filter by courier.
     */
    public function scopeByCourier($query, $courierId)
    {
        return $query->where('branch_courier_id', $courierId);
    }
}
