<?php

namespace Modules\Courier\app\Repositories;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Modules\Courier\app\Models\BranchCourier;

interface BranchCourierRepositoryInterface
{
    /**
     * Get all couriers with optional filters and pagination.
     *
     * @param array $filters
     * @param int $perPage
     * @return LengthAwarePaginator
     */
    public function getAll(array $filters = [], int $perPage = 15): LengthAwarePaginator;

    /**
     * Find a courier by its ID.
     *
     * @param int $id
     * @return BranchCourier|null
     */
    public function findById(int $id): ?BranchCourier;

    /**
     * Create a new courier with delivery times.
     *
     * @param array $data
     * @return BranchCourier
     */
    public function create(array $data): BranchCourier;

    /**
     * Update an existing courier by ID.
     *
     * @param int $id
     * @param array $data
     * @return bool
     */
    public function update(int $id, array $data): bool;

    /**
     * Soft delete a courier by ID.
     *
     * @param int $id
     * @return bool
     */
    public function delete(int $id): bool;

    /**
     * Search for users by name, family, or mobile.
     *
     * @param array $filters
     * @return array
     */
    public function searchUsers(array $filters): array;

    /**
     * Search and create courier (create user if not exists).
     *
     * @param array $data
     * @return BranchCourier
     */
    public function searchAndCreate(array $data): BranchCourier;
}
