<?php

namespace Modules\Courier\app\Repositories;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface CourierOrderRepositoryInterface
{
    /**
     * Get orders assigned to a specific courier by user_id.
     *
     * @param int $userId
     * @param array $filters
     * @param int $perPage
     * @return LengthAwarePaginator
     */
    public function getCourierOrders(int $userId, array $filters = [], int $perPage = 15): LengthAwarePaginator;

    /**
     * Get order statistics for a courier.
     *
     * @param int $userId
     * @param array $filters
     * @return array
     */
    public function getCourierOrderStats(int $userId, array $filters = []): array;
}
