<?php

namespace Modules\Courier\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Courier\app\Models\DeliveryTime;

class DeliveryTimeFactory extends Factory
{
    protected $model = DeliveryTime::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $startTime = $this->faker->time('H:i:s');
        $endTime = $this->faker->time('H:i:s', '+4 hours');

        return [
            'branch_courier_id' => 1, // You should create a proper courier factory
            'start_time' => $startTime,
            'end_time' => $endTime,
        ];
    }
}
