<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('branch_couriers', function (Blueprint $table) {
            $table->decimal('delivery_percent', 5, 2)->nullable()->after('address')->comment('درصد کمیسیون پیک');
            $table->string('phone', 20)->nullable()->after('delivery_percent')->comment('شماره تلفن پیک');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('branch_couriers', function (Blueprint $table) {
            $table->dropColumn(['delivery_percent', 'phone']);
        });
    }
};
