<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('branch_couriers', function (Blueprint $table) {
            $table->string('name')->nullable()->after('id');
            $table->string('family')->nullable()->after('name');
            $table->date('birth_date')->nullable()->after('family');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('branch_couriers', function (Blueprint $table) {
            $table->dropColumn('name');
            $table->dropColumn('family');
            $table->dropColumn('birth_date');
        });
    }
};
