<?php

namespace Modules\Courier\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Courier\app\Models\BranchCourier;
use Modules\Courier\app\Models\DeliveryTime;

class CourierSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create sample couriers
        $couriers = [
            [
                'address' => 'تهران، خیابان ولیعصر',
                'branch_id' => 1,
                'user_id' => 1,
            ],
            [
                'address' => 'اصفهان، خیابان چهارباغ',
                'branch_id' => 2,
                'user_id' => 2,
            ],
        ];

        foreach ($couriers as $courierData) {
            $courier = BranchCourier::create($courierData);

            // Create sample delivery times for each courier
            $deliveryTimes = [
                [
                    'start_time' => '08:00:00',
                    'end_time' => '12:00:00',
                ],
                [
                    'start_time' => '14:00:00',
                    'end_time' => '18:00:00',
                ],
            ];

            foreach ($deliveryTimes as $timeData) {
                DeliveryTime::create([
                    'branch_courier_id' => $courier->id,
                    'start_time' => $timeData['start_time'],
                    'end_time' => $timeData['end_time'],
                ]);
            }
        }
    }
}
