<?php

namespace Modules\Courier\Tests\Unit;

use Tests\TestCase;
use Modules\Courier\app\Models\BranchCourier;
use Modules\Courier\app\Models\DeliveryTime;
use Illuminate\Foundation\Testing\RefreshDatabase;

class CourierTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test courier creation.
     */
    public function test_can_create_courier(): void
    {
        $courier = BranchCourier::factory()->create();

        $this->assertDatabaseHas('branch_couriers', [
            'id' => $courier->id,
        ]);
    }

    /**
     * Test courier with delivery times creation.
     */
    public function test_can_create_courier_with_delivery_times(): void
    {
        $courier = BranchCourier::factory()->create();

        $deliveryTime = DeliveryTime::factory()->create([
            'branch_courier_id' => $courier->id,
        ]);

        $this->assertDatabaseHas('delivery_times', [
            'id' => $deliveryTime->id,
            'branch_courier_id' => $courier->id,
        ]);
    }

    /**
     * Test courier soft delete.
     */
    public function test_can_soft_delete_courier(): void
    {
        $courier = BranchCourier::factory()->create();
        $courier->delete();

        $this->assertSoftDeleted('branch_couriers', [
            'id' => $courier->id,
        ]);
    }
}
