<?php

namespace Modules\User\app\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Repositories\Setting\SettingRepository;
use App\Repositories\Transaction\TransactionRepository;
use App\Repositories\Coupon\CouponRepository;
use App\Repositories\User\CommentRepository;
use App\Repositories\User\UserRepository;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class ProfileController extends Controller
{
    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }


    public function getProfile()
    {
        $user = $this->userRepository->getProfileUser();

        // Calculate wallet balance (main wallet + branch cashback in single mode)
        $walletBalance = app(TransactionRepository::class)->userInventory();
        $setting = app(SettingRepository::class)->getSettingWithNames(['systemMode', 'branchSingleModeId']);
        if ($setting != null && isset($setting['systemMode']) && $setting['systemMode'] === 'single') {
            $cashBack = $this->userRepository->getWalletUserInBranch($setting['branchSingleModeId'] ?? null, auth()->id());
            if ($cashBack != null) {
                $walletBalance += $cashBack;
            }
        }

        $user->setAttribute('wallet_balance', (int)$walletBalance);

        return response()->json(['data' => $user], 200);
    }


    public function updateProfile(Request $request)
    {
        // Validate the request data
        $validator = Validator::make($request->all(), [
            'name' => 'nullable|string|max:255',
            'family' => 'nullable|string|max:255',
            'username' => 'nullable|string|max:255',
            'password' => 'nullable|string|max:255',
            'day' => 'nullable|numeric',
            'month' => 'nullable|numeric',
            'year' => 'nullable|numeric',
            'email' => 'nullable|email',
            'tel' => 'nullable|numeric',
        ]);

        // If validation fails, return the error response
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        // Get the authenticated user
        $user = auth()->user();

        $data = [];


        if (isset($request->name))
            $data['name'] = $request->input('name');

        if (isset($request->name))
            $data['family'] = $request->input('family');

        if (isset($request->name))
            $data['username'] = $request->input('username');

        if (isset($request->password))
            $data['password'] = Hash::make($request->input('password'));

        if (isset($request->day) and isset($request->month) and isset($request->year))
            $data['birth_date'] = $request->year . '/' . $request->month . '/' . $request->day;

        if (isset($request->tel))
            $data['tel'] = $request->tel;


        if (isset($request->email))
            $data['email'] = $request->email;


        // Update the user's profile
        $user->update($data);

        // Return a success response
        return response()->json(['message' => 'پروفایل با موفقیت ویرایش شد', 'data' => auth()->user()], 200);
    }


    public function setAddress($id)
    {
        $user = $this->userRepository->update(auth()->id(), ['default_address_id' => $id]);
        if ($user) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function getCouponActiveList()
    {
        $data = app(CouponRepository::class)->getActiveList();
        if ($data) {
            return response()->json(['data' => $data], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }


}
