<?php

namespace Modules\User\app\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Repositories\Order\OrderRepository;
use App\Repositories\User\UserRepository;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{

    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function sendCode(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|numeric',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        //check latest send code
        $check = $this->userRepository->checkLatestSmsCode($request->mobile);
        if ($check!=null) {
            return response()->json(['data' => ['message' => 'کد قبلا ارسال شده است', 'beforeSend' => true]], 200);
        }else {
            //send code
            $send = $this->userRepository->sendSmsCode($request->mobile);
//            if ($send)
            return response()->json(['data' => ['message' => 'کد با موفقیت انجام شد']], 200);
//            else
//                return response()->json(['data' => ['message' => 'عملیات با شکست مواجه شد']], 400);
        }
        return response()->json(['data' => ['message' => 'عملیات با شکست مواجه شد']], 500);
    }


    function checkCode(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|ir_mobile',
            'code' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $check = $this->userRepository->checkSmsCode($request->mobile, $request->code);
        if (!$check)
            return response()->json(['data' => ['message' => 'کد منقضی شده است دوباره ارسال شد']], 400);
        else {
            if ($check == "success") {
                $user=$this->userRepository->getProfileUser();
                Log::info("Cdscds");
                Log::info($request->hasHeader('GuestToken'));
                if ($request->hasHeader('GuestToken'))
                    app(OrderRepository::class)->updateGustOrderUserId($user->id, $request->header('GuestToken'));
                $token = Auth::user()->createToken('Authenticate')->accessToken;
                return response()->json(['data' => ['message' => 'شما با موفقیت وارد شدید', 'token' => $token, 'user' => $this->userRepository->getProfileUser()]], 200);
            } else {
                return response()->json(['data' => ['message' => 'کد وارد شدن صحیح نیست']], 400);
            }
        }
        return response()->json(['data' => ['message' => 'عملیات با شکست مواجه شد']], 500);
    }


}
