<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('voip_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendor_id')->constrained()->onDelete('cascade'); // کلید خارجی به جدول فروشندگان
            $table->foreignId('branch_id')->constrained()->onDelete('cascade'); // کلید خارجی به جدول شعب
            $table->string('token')->unique(); // توکن اختصاصی
            $table->timestamp('expires_at')->nullable(); // زمان انقضا
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendor_tokens');
    }
};
