<?php

namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Support\Facades\Log;
use Morilog\Jalali\Jalalian;

class JalaliDateCast implements CastsAttributes
{
    public function get($model, $key, $value, $attributes)
    {
        return Jalalian::fromDateTime($value)->format('Y/m/d');
    }
    public function set($model, $key, $value, $attributes)
    {
        try {
            return Jalalian::fromFormat('Y/m/d', $value)->toCarbon()->toDateString();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return "";
        }
    }
}
