<?php

namespace App\Console\Commands;

use App\Enums\OrderStatus;
use Illuminate\Console\Command;
use App\Models\Order;
use Illuminate\Support\Facades\Bus;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class DeleteOldOrders extends Command
{
    protected $signature = 'orders:process-old';
    protected $description = 'حذف سفارش‌هایی که برای یک ساعت قبل هستند';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $oneHourAgo = Carbon::now()->subHour();

        $oldOrders = Order::whereIn('order_status', [
            OrderStatus::ORDERING->value,
            OrderStatus::WATINGPAYMENT->value
        ])
            ->where('created_at', '<', $oneHourAgo)
            ->get();

        Log::info('تعداد سفارش‌های پیدا شده: ' . $oldOrders->count());
        Log::info('زمان یک ساعت پیش: ' . $oneHourAgo);

        if ($oldOrders->isEmpty()) {
            $this->info('هیچ سفارشی برای پردازش وجود ندارد.');
            return;
        }

        $jobs = $oldOrders->map(function ($order) {
            return new \App\Jobs\ProcessDeleteOrderJob($order->id);
        });

        Bus::batch($jobs)->dispatch();

        $this->info('Job‌ها برای پردازش سفارش‌ها ارسال شدند.');
    }
}
