<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Order;
use Illuminate\Support\Carbon;

class PurgeOldOrders extends Command
{
    protected $signature = 'orders:purge-old {--hours=3} {--status=}';
    protected $description = 'Delete orders older than given hours (default: 3). Optionally filter by status.';

    public function handle(): int
    {
        $hours  = (int) ($this->option('hours') ?? 3);
        $cutoff = Carbon::now()->subHours($hours);

        $q = Order::query()->where('created_at', '<', $cutoff);
        if ($this->option('status')) {
            $q->where('status', $this->option('status')); // اختیاری
        }
        $deleted = $q->delete();

        $this->info("Deleted {$deleted} orders older than {$hours} hours.");
        return self::SUCCESS;
    }
}
