<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */

     protected $commands = [
        \App\Console\Commands\PurgeOldOrders::class,
        \App\Console\Commands\SendOpenOrderReminders::class,
        \App\Console\Commands\SendOrderDelayApprovalReminders::class,
        \App\Console\Commands\SendOrderDelayDeliveryReminders::class,

    ];

    protected function schedule(Schedule $schedule): void
    {
        Artisan::call('orders:process-old');


//        $schedule->command('orders:purge-old')->everyThreeHours()->withoutOverlapping()->onOneServer();

       // $schedule->command('orders:send-open-reminders')
        //->everyMinute()
        //->withoutOverlapping()
        //->onOneServer();

        // ارسال یادآوری تاخیر تایید سفارش هر 5 دقیقه
        $schedule->command('orders:send-delay-approval-reminders')
            ->everyFiveMinutes()
            ->withoutOverlapping()
            ->onOneServer();

        // ارسال یادآوری تاخیر تحویل سفارش هر 10 دقیقه
        $schedule->command('orders:send-delay-delivery-reminders')
            ->everyTenMinutes()
            ->withoutOverlapping()
            ->onOneServer();

//        $schedule->command('orders:process-old')->everyMinute();

    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}
