<?php

namespace App\Enums;

enum HolidayReasonType: string
{
    case POWER_OUTAGE = 'power_outage';
    case INTERNAL_REPAIRS = 'internal_repairs';
    case EQUIPMENT_FAILURE = 'equipment_failure';
    case LOCATION_MOVE = 'location_move';
    case NO_DELIVERY_PERSON = 'no_delivery_person';
    case FOOD_SUPPLIES_FINISHED = 'food_supplies_finished';
    case HOLIDAYS = 'holidays';
    case NO_SERVICE = 'no_service';
    case WEATHER_CONDITION = 'weather_condition';
    case MENU_UPDATE = 'menu_update';
    case NO_STAFF = 'no_staff';
    case OTHER = 'other';

    /**
     * Get the Persian label for the holiday reason
     */
    public function getLabel(): string
    {
        return match($this) {
            self::POWER_OUTAGE => 'قطعی برق،گازو...',
            self::INTERNAL_REPAIRS => 'تعمیرات داخلی',
            self::EQUIPMENT_FAILURE => 'خرابی تجهیزات',
            self::LOCATION_MOVE => 'جابجایی مکانی',
            self::NO_DELIVERY_PERSON => 'عدم وجود پیک',
            self::FOOD_SUPPLIES_FINISHED => 'اتمام غذا و مواد اولیه',
            self::HOLIDAYS => 'تعطیلات',
            self::NO_SERVICE => 'عدم سرویس دهی',
            self::WEATHER_CONDITION => 'وضعیت آب و هوا',
            self::MENU_UPDATE => 'اپدیت منو',
            self::NO_STAFF => 'نداشتن پرسنل',
            self::OTHER => 'سایر موارد',
        };
    }

    /**
     * Get all holiday reason types with their labels
     */
    public static function getOptions(): array
    {
        $options = [];
        foreach (self::cases() as $case) {
            $options[$case->value] = $case->getLabel();
        }
        return $options;
    }

    /**
     * Get holiday reason type by value
     */
    public static function fromValue(string $value): ?self
    {
        return self::tryFrom($value);
    }
}
