<?php

namespace App\Enums;

enum NotificationType: string
{
    case ORDER_NEW = 'order_new';
    case ORDER_CANCELLED = 'order_cancelled';
    case ORDER_READY = 'order_ready';
    case TICKET_NEW = 'ticket_new';
    case TICKET_ANSWERED = 'ticket_answered';
    case DRIVER_ASSIGNED = 'driver_assigned';
    case PAYMENT_RECEIVED = 'payment_received';
    case SYSTEM_ALERT = 'system_alert';
    case ORDER_DELAY_APPROVAL = 'order_delay_approval';
    case ORDER_DELAY_DELIVERY = 'order_delay_delivery';
    case PRODUCT_INACTIVE = 'product_inactive';

    /**
     * Get all notification types as array
     */
    public static function getAll(): array
    {
        return array_column(self::cases(), 'value');
    }

    /**
     * Get notification type label in Persian
     */
    public function getLabel(): string
    {
        return match($this) {
            self::ORDER_NEW => 'سفارش جدید',
            self::ORDER_CANCELLED => 'لغو سفارش',
            self::ORDER_READY => 'آماده شدن سفارش',
            self::TICKET_NEW => 'تیکت جدید',
            self::TICKET_ANSWERED => 'پاسخ تیکت',
            self::DRIVER_ASSIGNED => 'انتساب راننده',
            self::PAYMENT_RECEIVED => 'دریافت پرداخت',
            self::SYSTEM_ALERT => 'هشدار سیستم',
            self::ORDER_DELAY_APPROVAL => 'تاخیر تایید سفارش',
            self::ORDER_DELAY_DELIVERY => 'تاخیر تحویل سفارش',
            self::PRODUCT_INACTIVE => 'محصولات غیرفعال',
        };
    }

    /**
     * Get notification type description
     */
    public function getDescription(): string
    {
        return match($this) {
            self::ORDER_NEW => 'پیامک سفارش جدید برای رستوران',
            self::ORDER_CANCELLED => 'پیامک لغو سفارش برای رستوران',
            self::ORDER_READY => 'پیامک آماده شدن سفارش برای راننده',
            self::TICKET_NEW => 'پیامک تیکت جدید برای ادمین',
            self::TICKET_ANSWERED => 'پیامک پاسخ تیکت برای ادمین',
            self::DRIVER_ASSIGNED => 'پیامک انتساب راننده برای رستوران',
            self::PAYMENT_RECEIVED => 'پیامک دریافت پرداخت برای رستوران',
            self::SYSTEM_ALERT => 'پیامک هشدارهای سیستم برای ادمین',
            self::ORDER_DELAY_APPROVAL => 'پیامک تاخیر تایید سفارش برای رستوران',
            self::ORDER_DELAY_DELIVERY => 'پیامک تاخیر تحویل سفارش برای مشتری',
            self::PRODUCT_INACTIVE => 'پیامک یادآوری محصولات غیرفعال برای رستوران',
        };
    }
}
