<?php

namespace App\Enums;

enum PopupAlarmPageType: string
{
    case HOME = 'home';
    case CART_CHECK = 'cart_check';
    case CART_PAYMENT = 'cart_payment';

    /**
     * دریافت لیست تمام صفحات
     */
    public static function getAll(): array
    {
        return [
            self::HOME->value => 'صفحه اصلی',
            self::CART_CHECK->value => 'سبد خرید چک',
            self::CART_PAYMENT->value => 'سبد خرید پرداخت',
        ];
    }

    /**
     * دریافت نام فارسی صفحه
     */
    public function getLabel(): string
    {
        return match($this) {
            self::HOME => 'صفحه اصلی',
            self::CART_CHECK => 'سبد خرید چک',
            self::CART_PAYMENT => 'سبد خرید پرداخت',
        };
    }

    /**
     * بررسی اینکه آیا مقدار معتبر است یا نه
     */
    public static function isValid(string $value): bool
    {
        return in_array($value, array_column(self::cases(), 'value'));
    }
}
