<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class NotificationOrder implements ShouldBroadcastNow{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $order;
    public $branch;

    public function __construct($order)
    {
        $this->order = $order;
        $this->branch = $order->branch;
    }

    public function broadcastOn()
    {
        return ['notification-orders.' . $this->branch->id ?? 0];
    }

    public function broadcastWith()
    {
        return [
            'order_id' => $this->order->id,
        ];
    }

    public function broadcastAs()
    {
        return 'notification-orders';
    }


}
