<?php

namespace App\Events;

use App\Models\PrinterSetting;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class PrintOrder implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /** @var int */
    public int $orderId;

    /** @var int */
    public int $branchId;

    public function __construct($order)
    {
        $this->orderId  = (int) ($order->id ?? 0);
        $this->branchId = (int) ($order->branch->id ?? 0);
    }

    public function broadcastOn()
    {
        return new Channel('print-order.' . ($this->branchId ?: 0));

    }

    public function broadcastAs()
    {
        return 'notification-orders';
    }

    public function broadcastWith()
    {
        return [
            'order_id'   => $this->orderId,
            'branch_id'  => $this->branchId,
            'printers'   => $this->getBranchPrinters($this->branchId),
          
        ];
    }

    
    protected function getBranchPrinters(int $branchId): array
    {
        if ($branchId <= 0) {
            return [];
        }

        return PrinterSetting::query()
            ->where('branch_id', $branchId)
            ->where('status', 'active')
            ->orderBy('id')
            ->get(['id','name','title','type','size','options'])
            ->map(function (PrinterSetting $p) {
                return [
                    'id'      => $p->id,
                    'name'    => $p->name,
                    'title'   => $p->title,  
                    'type'    => $p->type,   
                    'size'    => $p->size,   
                    'options' => $p->options 
                ];
            })
            ->values()
            ->all();
    }

 
}
