<?php

namespace App\Exports;

use App\Repositories\Activity\ActivityRepository;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromCollection;
use function Symfony\Component\Translation\t;

class BranchesExport implements FromCollection
{
    protected $ranches;

    public function __construct(array $ranches)
    {
        $this->ranches = $ranches;
    }

    public function collection()
    {
        $rows = collect();
        $rows->push([
            "شناسه",
            "نام آشپز",
            "آدرس",
            "lat",
            "lng",
            "دسته بندی",
            "منطقه",
            "توضیحات",
            "حوزه فعالیت",
            "وعده های غذایی",
            "امتیاز",

        ]);
        foreach ($this->ranches as $item) {
            $rows->push([
                $item['id'],
                $item['title'] ?? '-',
                $item['address'] ?? '-',
                $item['lat'] ?? '-',
                $item['lng'] ?? '-',
                $item['category']['title'] ?? '-',
                $item['area']['title'] ?? '-',
                $item['description'] ?? '-',
                ($item['activities']!=null)? json_encode(app(ActivityRepository::class)->getWithArrayId(json_decode($item['activities'],true))->pluck('title')->toArray(),JSON_UNESCAPED_UNICODE) ?? '-':'-',
                $item['meals'] ?? '-',
            ]);
        }
        return $rows;
    }
}
