<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;

class MaterialsExport implements FromCollection
{
    protected $materials;

    public function __construct(array $materials)
    {
        $this->materials = $materials;
    }

    public function collection()
    {
        $rows = collect();
        $rows->push([
            "شناسه",
            "عنوان",
            "واحد",
            "قیمت هر واحد",
            "کالری هر واحد",
            "کربوهیدارت هر واحد",
            "پروتئین هر واحد",
            "چربی هر واحد",
            "دسته بندی"
        ]);
        foreach ($this->materials as $item) {
            $rows->push([
                $item['id'],
                $item['title'] ?? '-',
                $item['unit']['title'] ?? '-',
                $item['price_per_unit'] ?? '-',
                $item['calorie_per_unit'] ?? '-',
                $item['carbohydrate_per_unit'] ?? '-',
                $item['protein_per_unit'] ?? '-',
                $item['fat_per_unit'] ?? '-',
                $item['category']['title'] ?? '-'
            ]);
        }
        return $rows;
    }
}
