<?php

namespace App\Exports;

use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromCollection;

class OrdersExport implements FromCollection
{
    protected $orders;

    public function __construct(array $orders)
    {
        $this->orders = $orders;
    }

    public function collection()
    {
        $rows = collect();
        $rows->push([
            "شماره سفارش",
            "نام آشپز",
            "وضعیت سفارش",
            " نوع پرداخت",
            "هزینه سفارش",
            "هزینه ارسال",
            "هزینه مالیات",
            "زمان ثبت",
            "زمان تحویل",
            "آدرس",

        ]);
        foreach ($this->orders as $item) {
            $rows->push([
                $item['id'],
                $item['branch']['title'] ?? '-',
                $item['order_status'] ?? '-',
                $item['payment_type'] ?? '-',
                $item['order_price'] ?? '-',
                $item['delivery_price'] ?? '-',
                $item['tax_price'] ?? '-',
                jdate($item['created_at']),
                $item['delivery_time'] ?? '- ',
                json_decode($item['address'], true)['address'] ?? '- '
            ]);
        }
        return $rows;
    }
}
