<?php

namespace App\Exports;

use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromCollection;

class ProductsExport implements FromCollection
{
    protected $orders;

    public function __construct(array $orders)
    {
        $this->orders = $orders;
    }

    public function collection()
    {
        $rows = collect();
        $rows->push([
            "شناسه محصول",
            "نام آشپز",
            "دسته بندی",
            "عنوان",
            "توصیحات",
            "کالری",
            "امتیاز",
            "قیمت",
            "قیمت بسته بندی",
            "درصد تخفیف",
            "تعداد",
            "متریال",

        ]);
        foreach ($this->orders as $item) {
            $material = "";
            if ($item['material'] !== null) {
                foreach ($item['material'] as $mat) {
                    $material = $material . ' - ' . $mat['title'] . '(' . $mat['pivot']['usage_per_unit'] . ')';
                }
            }
            $rows->push([
                $item['id'],
                $item['branch']['title'] ?? '-',
                $item['category']['title'] ?? '-',
                $item['title'] ?? '-',
                $item['description'] ?? '-',
                $item['calory'] ?? '-',
                $item['rate'] ?? '-',
                $item['variety']['price'] ?? '-',
                $item['variety']['price_paking'] ?? '-',
                $item['variety']['discount'] ?? '-',
                $item['variety']['count'] ?? '-',
                $material ?? '-',
            ]);
        }
        return $rows;
    }
}
