<?php

namespace App\Exports;

use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromCollection;

class TransactionsExport implements FromCollection
{


    protected $transactions;

    public function __construct(array $transactions)
    {
        $this->transactions = $transactions;
    }

    public function collection()
    {
        $rows = collect();

        $rows->push([
            "شناسه",
            "تاریخ",
            "نام",
            " نام خانوادگی",
            "مبلغ",
            "توضیحات",
            "نوع تراکنش"
        ]);
        foreach ($this->transactions as $item) {
            $rows->push([
                $item['id'],
                jdate($item['created_at']),
                $item['user']['name'] ?? '- ',
                $item['user']['family'] ?? '- ',
                $item['amount'],
                $item['description'],
                $item['transaction_type']
            ]);
        }
        return $rows;
    }
}
