<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;

class UsersExport implements FromCollection
{
    protected $users;

    public function __construct(array $users)
    {
        $this->users = $users;
    }
    public function collection()
    {
        $rows = collect();
        $rows->push([
            "شناسه",
            "نام",
            "نام خانوادگی",
            "شماره موبایل",
            " ایمیل",
            "تاریخ تولد",
            "کد معرفی"
        ]);
        foreach ($this->users as $item) {
            $rows->push([
                $item['id'],
                $item['name'] ?? '-',
                $item['family'] ?? '-',
                $item['mobile'] ?? '-',
                $item['email'] ?? '-',
                $item['birth_date'] ?? '-',
                $item['referral_code'] ?? '-',
            ]);
        }
        return $rows;
    }
}
