<?php


function sms_result($code)
{
    switch ($code) {
        case 1:
        case 0:
            return '1 - ارسال با موفقیت انجام شد.';
        case 2:
            return '2 - کاربر مسدود شده است.';
        case 3:
            return '3 - شماره فرستنده نامعتبر است';
        case 4:
            return '4 - محدودیت در ارسال روزانه.';
        case 5:
            return '5 - تعداد گیرندگان حداکثر 110 شماره می باشد.';
        case 6:
            return '6 - خط فرستنده غیر فعال است.';
        case 7:
            return '7 - متن پیامک شامل کلمات فیلتر شده است.';
        case 8:
            return '8 - اعتبار کافی نیست.';
        case 9:
            return '9 - سامانه در حال بروز رسانی می باشد.';
        case 10:
            return '10 - وب سرویس غیرفعال است.';
    }
}

function generate_seo_url($string)
{
    $string = str_replace(' ', '-', $string);
    $string = str_replace('/', '_', $string);
    return $string;
}

function PriceCalculation($fi, $priceValue)
{
    return $fi - (($fi / 100) * $priceValue);
}


function haversineDistance($point1, $point2)
{
    $earthRadius = 6371; // Earth's radius in kilometers

    $lat1 = deg2rad($point1['latitude']);
    $lon1 = deg2rad($point1['longitude']);
    $lat2 = deg2rad($point2['latitude']);
    $lon2 = deg2rad($point2['longitude']);

    $dlat = $lat2 - $lat1;
    $dlon = $lon2 - $lon1;

    $a = sin($dlat / 2) ** 2 + cos($lat1) * cos($lat2) * sin($dlon / 2) ** 2;
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

    $distance = $earthRadius * $c;

    return $distance;
}

function handelError($type, $message)
{
    \Illuminate\Support\Facades\Log::info($message);
}
