<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;

class BaseController extends Controller
{
    public function sendResponse($data=[], $message = '', $status = true, $code = 200)
    {
        return response()->json([
            'message' => $message,
            'data' => $data,
            'status' => $status,
        ], $code);
    }

    public function sendError($message = '', $data = [], $code = 404)
    {
        return response()->json([
            'message' => $message,
            'data' => $data,
            'status' => false,
        ], $code);
    }
}
