<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Agent\AgentRepository;
use App\Repositories\User\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AgentController extends Controller
{
    protected $agentRepository;

    public function __construct()
    {
        $this->agentRepository = app(AgentRepository::class);
    }

    public function index(Request $request)
    {
        $users = $this->agentRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $users]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:50',
            'family' => 'required|string|max:50',
            'national_code' => 'required|string|max:11',
            'mobile' => 'required|unique:agents',
            'code' => 'required|unique:agents',
            'birthday' => 'required|date:Y/m/d',
            'address' => 'required|string|max:255',
            'lat' => 'required|numeric|between:-90,90',
            'lng' => 'required|numeric|between:-180,180',
            'area_id' => 'required|numeric|exists:areas,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['data' => [], 'status' => 422, 'message' => $validator->errors()->first()], 422);
        }


        //checkUser
        $user = app(UserRepository::class)->getUserWithMobile($request->mobile);
        if ($user!=null and $user->role_id != 0)
            return response()->json(['data' => [], 'status' => 422, 'message' => 'شماره موبایل وارد شده دارای نقش می باشد.'], 422);

        $agent = $this->agentRepository->store($request->all());
        if ($agent) {
            if ($user == null) {
                app(UserRepository::class)->storeP([
                    'name' => $request->name,
                    'family' => $request->family,
                    'mobile' => $request->mobile,
                    'role_id' => 7,
                    'target_role_id' => $agent['id']
                ]);

            } else {

                app(UserRepository::class)->update($user->id, [
                    'role_id' => 7,
                    'target_role_id' => $agent->id
                ]);

            }
            return response()->json(['data' => $agent, 'status' => 200, 'message' => '']);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد', 'data' => [], 'status' => 500], 500);
    }

    public function show($id)
    {
        $agent = $this->agentRepository->show($id);
        if (!$agent) {
            return response()->json(['message' => 'هیچ موردی یافت نشد', 'data' => [], 'status' => 404], 404);
        }
        return response()->json(['data' => $agent, 'message' => '', 'status' => 200]);
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:50',
            'family' => 'required|string|max:50',
            'national_code' => 'required|string|max:11',
            'mobile' => 'required|unique:agents,mobile,' . $id,
            'code' => 'required|unique:agents,code,' . $id,
            'birthday' => 'required|date:Y/m/d',
            'address' => 'required|string|max:255',
            'lat' => 'required|numeric|between:-90,90',
            'lng' => 'required|numeric|between:-180,180',
            'area_id' => 'required|numeric|exists:areas,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['data' => [], 'status' => 422, 'message' => $validator->errors()->first()], 422);
        }


        //checkUser
        $user = app(UserRepository::class)->getUserWithMobile($request->mobile);
        if ($user!=null and $user->role_id != 0 and $user->target_role_id != $id)
            return response()->json(['data' => [], 'status' => 422, 'message' => 'شماره موبایل وارد شده دارای نقش می باشد.'], 422);


        $agent = $this->agentRepository->update($id, $request->all());


        if ($agent) {
            if ($user == null) {
                app(UserRepository::class)->store([
                    'name' => $request->name,
                    'family' => $request->family,
                    'mobile' => $request->mobile,
                    'role_id' => 7,
                    'target_role_id' => $id
                ]);
            } elseif ($user->target_role_id != $id) {
                app(UserRepository::class)->update($user->id, [
                    'role_id' => 7,
                    'target_role_id' => $id
                ]);
            }
            return response()->json(['message' => 'عملیات با موفقیت انجام شد', 'data' => [], 'status' => 200]);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد', 'data' => [], 'status' => 500], 500);
    }

    public function destroy($id)
    {

        $user = $this->agentRepository->destroy($id);
        if (!$user) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'با موفقیت حذف شد '], 200);
    }
}
