<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Comment\CommentRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class CommentController extends Controller
{
    protected $commentRepository;

    public function __construct()
    {
        $this->commentRepository = app(CommentRepository::class);
    }

    public function index(Request $request)
    {
        $branches = $this->commentRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $branches]);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'comment_id' => 'nullable|numeric|exists:comments,id',
        ]);
        if ($validator->fails())
            return response()->json(['error' => $validator->errors()->first()], 400);

        $branches = $this->commentRepository->showA($request->comment_id, true);

        return response()->json(['data' => $branches]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required',
            'parent_id' => 'nullable|numeric|exists:comments,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $data = $request->all();
        $data['user_id'] = auth()->id();
        $comment = $this->commentRepository->store($data);
        if ($comment) {
            return response()->json(['data' => $comment], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }


    public function toggleApproval(Request $request)
    {

        if (auth()->user()->role_id != 1) {
            return response()->json(['error' => 'فقط ادمین می‌تواند نظرات را تایید کند'], 403);
        }

        $validator = Validator::make($request->all(), [
            'comment_id' => 'required|numeric|exists:comments,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $comment = $this->commentRepository->showA($request->comment_id);
        if (!$comment) {
            return response()->json(['error' => 'نظر یافت نشد'], 404);
        }

        $updated = $this->commentRepository->toggleApproval($request->comment_id);
        if ($updated) {
            $message = $updated->admin_approve ? 'نظر تایید شد' : 'نظر تایید نشد';
            return response()->json(['message' => $message, 'data' => $updated]);
        }

        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }
}
