<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Models\Branch;
use App\Models\Order;
use App\Models\Transaction;
use App\Models\User;
use App\Repositories\Order\OrderRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    protected $orderRep;

    public function __construct()
    {
        $this->orderRep = app(OrderRepository::class);
    }

    public function getCount(Request $request)
    {
        if (isset($request->branch_id)) {
            $orders = $this->orderRep->getWithFilter(["branch_id" => $request->branch_id]);
            return response()->json(['data' => [
                "orders" => $orders
            ]], 200);
        }
        if (isset($request->driver_id)) {
            $orders = $this->orderRep->getWithFilter(["driver_id" => $request->driver_id]);
            return response()->json(['data' => [
                "orders" => $orders
            ]], 200);
        }
        if (isset($request->agent_id)) {
            $orders = $this->orderRep->getWithFilter(["agent_id" => $request->agent_id]);
            return response()->json(['data' => [
                "orders" => $orders
            ]], 200);
        }
        $branches = Branch::get()->count();
        $transaction = Transaction::get()->count();
        $orders = $this->orderRep->getWithFilter([$request->branch_id ?? null]);
        $users = User::get()->count();
        $province = Area::where('parent_id', 0)->get()->count();
        $city = Area::where('parent_id', '!=', 0)->get()->count();
        return response()->json(['data' => [
            "branches" => $branches,
            "transaction" => $transaction,
            "orders" => $orders,
            "users" => $users,
            "province" => $province,
            "city" => $city
        ]], 200);
    }


    public function getLatestUserRegisterCount(Request $request)
    {
        $counts = $this->orderRep->getLatestUserRegisterCount();
        return response()->json(['data' => [
            'counts' => $counts
        ]], 200);
    }



}
