<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Extra\ExtraRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ExtraController extends Controller
{

    protected $extraRepository;

    public function __construct()
    {
        $this->extraRepository = app(ExtraRepository::class);
    }

    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'search' => 'nullable',
            'branch_id' => 'required|numeric|exists:branches,id',
            'extra_type_id' => 'required|numeric|exists:extra_types,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extras = $this->extraRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $extras]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'branch_id' => 'required|numeric|exists:branches,id',
            'price' => 'required|numeric',
            'extra_type_id' => 'required|numeric|exists:extra_types,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extra = $this->extraRepository->store($request->all());

        if ($extra) {
            return response()->json(['data' => $extra], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);


    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'extra_id' => 'required|numeric|exists:extras,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extra = $this->extraRepository->show($request->extra_id);

        if (!$extra) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $extra]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'branch_id' => 'required|numeric|exists:branches,id',
            'price' => 'required|numeric',
            'extra_type_id' => 'nullable|numeric|exists:extra_types,id',
            'extra_id' => 'required|numeric|exists:extras,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $extra = $this->extraRepository->update($request->extra_id, $request->all());
        if ($extra) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'extra_id' => 'required|numeric|exists:extras,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extra = $this->extraRepository->destroy($request->extra_id);
        if (!$extra) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'با موفقیت حذف شد '], 200);
    }
}
